//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Threading;

namespace ThreadHelloWorld
{
	/// <summary>
	/// Podsumowanie dla Class1.
	/// </summary>
	class MulticastThread
	{
		static ManualResetEvent stopEvent;
		static void ThreadEntry1()
		{
			Thread currentThread = Thread.CurrentThread;
			Console.WriteLine("Witaj wiecie z ThreadEntry1 {0} {1}!",
				              currentThread.GetHashCode(),
				              Environment.TickCount);
			stopEvent.WaitOne();
		}
		static void ThreadEntry2()
		{
			Thread currentThread = Thread.CurrentThread;
			Console.WriteLine("Witaj wiecie z ThreadEntry2 {0} {1}!",
				               currentThread.GetHashCode(),
				               Environment.TickCount);
		}
		static void Main(string[] args)
		{
			stopEvent = new ManualResetEvent(false);
			ThreadStart tsd = new ThreadStart(ThreadEntry1);
			tsd += new ThreadStart(ThreadEntry2);
			Thread t = new Thread(tsd);
			t.Start();
			Thread.Sleep(1000);
			stopEvent.Set();
			t.Join();
		}
	}
}
